% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFLOMICS-Methods_04_diff_analysis.R
\name{runDiffAnalysis}
\alias{runDiffAnalysis}
\alias{runDiffAnalysis,RflomicsSE-method}
\alias{runDiffAnalysis,RflomicsMAE-method}
\alias{filterDiffAnalysis}
\alias{filterDiffAnalysis,RflomicsSE-method}
\alias{filterDiffAnalysis,RflomicsMAE-method}
\alias{setValidContrasts}
\alias{setValidContrasts,RflomicsSE-method}
\alias{setValidContrasts,RflomicsMAE-method}
\alias{plotDiffAnalysis}
\alias{plotDiffAnalysis,RflomicsSE-method}
\alias{plotDiffAnalysis,RflomicsMAE-method}
\alias{plotHeatmapDesign}
\alias{plotHeatmapDesign,RflomicsSE-method}
\alias{plotHeatmapDesign,RflomicsMAE-method}
\alias{plotBoxplotDE}
\alias{plotBoxplotDE,RflomicsSE-method}
\alias{plotBoxplotDE,RflomicsMAE-method}
\alias{getDEMatrix}
\alias{getDEMatrix,RflomicsSE-method}
\alias{getDEMatrix,RflomicsMAE-method}
\alias{getDEList}
\alias{getDEList,RflomicsSE-method}
\alias{getDEList,RflomicsMAE-method}
\alias{getDiffSettings}
\alias{getDiffSettings,RflomicsSE-method}
\alias{getDiffSettings,RflomicsMAE-method}
\alias{getValidContrasts}
\alias{getValidContrasts,RflomicsSE-method}
\alias{getValidContrasts,RflomicsMAE-method}
\alias{getDiffStat}
\alias{getDiffStat,RflomicsSE-method}
\alias{getDiffStat,RflomicsMAE-method}
\alias{getDiffAnalysesSummary}
\alias{getDiffAnalysesSummary,RflomicsMAE-method}
\title{Run Differential Expression Analysis and process results}
\usage{
\S4method{runDiffAnalysis}{RflomicsSE}(
  object,
  contrastList = NULL,
  method = NULL,
  p.adj.method = "BH",
  p.adj.cutoff = 0.05,
  logFC.cutoff = 0,
  cmd = FALSE,
  ...
)

\S4method{runDiffAnalysis}{RflomicsMAE}(
  object,
  SE.name,
  contrastList = NULL,
  method = NULL,
  p.adj.method = "BH",
  p.adj.cutoff = 0.05,
  logFC.cutoff = 0,
  cmd = FALSE,
  ...
)

\S4method{filterDiffAnalysis}{RflomicsSE}(object, p.adj.cutoff = 0.05, logFC.cutoff = 0)

\S4method{filterDiffAnalysis}{RflomicsMAE}(object, SE.name, p.adj.cutoff = 0.05, logFC.cutoff = 0)

\S4method{setValidContrasts}{RflomicsSE}(object, contrastList = NULL)

\S4method{setValidContrasts}{RflomicsMAE}(object, omicName = NULL, contrastList = NULL)

\S4method{plotDiffAnalysis}{RflomicsSE}(
  object,
  contrastName,
  typeofplots = c("MA.plot", "volcano", "histogram")
)

\S4method{plotDiffAnalysis}{RflomicsMAE}(
  object,
  SE.name,
  contrastName,
  typeofplots = c("MA.plot", "volcano", "histogram")
)

\S4method{plotHeatmapDesign}{RflomicsSE}(
  object,
  contrastName,
  splitFactor = "none",
  title = "",
  annotNames = NULL,
  modalities = NULL,
  drawArgs = list(),
  heatmapArgs = list()
)

\S4method{plotHeatmapDesign}{RflomicsMAE}(
  object,
  SE.name,
  contrastName,
  splitFactor = "none",
  title = "",
  annotNames = NULL,
  modalities = NULL,
  drawArgs = list(),
  heatmapArgs = list()
)

\S4method{plotBoxplotDE}{RflomicsSE}(object, featureName = NULL, groupColor = "groups", raw = FALSE)

\S4method{plotBoxplotDE}{RflomicsMAE}(
  object,
  SE.name,
  featureName = NULL,
  groupColor = "groups",
  raw = FALSE
)

\S4method{getDEMatrix}{RflomicsSE}(object)

\S4method{getDEMatrix}{RflomicsMAE}(object, SE.name)

\S4method{getDEList}{RflomicsSE}(object, contrasts = NULL, operation = "union")

\S4method{getDEList}{RflomicsMAE}(object, SE.name, contrasts = NULL, operation = "union")

\S4method{getDiffSettings}{RflomicsSE}(object)

\S4method{getDiffSettings}{RflomicsMAE}(object, SE.name)

\S4method{getValidContrasts}{RflomicsSE}(object)

\S4method{getValidContrasts}{RflomicsMAE}(object, omicName)

\S4method{getDiffStat}{RflomicsSE}(object)

\S4method{getDiffStat}{RflomicsMAE}(object, SE.name = NULL)

\S4method{getDiffAnalysesSummary}{RflomicsMAE}(
  object,
  plot = FALSE,
  ylabelLength = 30,
  nbMaxLabel = 20,
  interface = FALSE
)
}
\arguments{
\item{object}{An object of class \link{RflomicsSE} or
class \link{RflomicsMAE-class}}

\item{contrastList}{A data.frame of contrast}

\item{method}{A character vector giving the name of the differential
analysis method to run. Either "edgeRglmfit" or "limmalmFit".}

\item{p.adj.method}{The method chosen to adjust pvalue. Takes the same
values as the ones of adj.p.adjust method.}

\item{p.adj.cutoff}{adjusted pvalue cutoff. Default is the parameter from
the differential analysis.}

\item{logFC.cutoff}{cutoff for absolute value of log2FC. Default is the
parameter from the differential analysis.}

\item{cmd}{Boolean. Used in the interface. If TRUE, print cmd for the user.}

\item{...}{Additional arguments.}

\item{SE.name}{SE.name the name of the dataset if the input object
is a \link{RflomicsMAE-class}}

\item{omicName}{a dataset name}

\item{contrastName}{The contrastName for which the MAplot has to be drawn}

\item{typeofplots}{The plots you want to return. Default is all possible
plots: MA plot, Volcano plot and non adjusted pvalues histogram.}

\item{splitFactor}{characters. Default to none. Name of a feature in the
design matrix, splits the samples on the heatmap according to its modalities.}

\item{title}{characters. Title of the heatmap.}

\item{annotNames}{vector. Names of the annotations to keep in the Heatmap.
Default takes all available information.}

\item{modalities}{named list of vectors of modalities to subset and print
on the heatmap.}

\item{drawArgs, heatmapArgs}{named lists. Any additional parameter passed
to ComplexHeatmap::Heatmap or ComplexHeatmap::draw}

\item{featureName}{variable name (gene/protein/metabolite name)}

\item{groupColor}{default to groups, indicate a variable in the design to
color the boxplots accordingly.}

\item{raw}{Boolean. Plot the raw data or the transformed ones (TRUE)}

\item{contrasts}{Vector of characters, expect to be contrast names.
Default is null, the operation (union) is performed
on every contrasts found.}

\item{operation}{character. Either union or intersection.
Defines the operation to perform on the DE lists from the contrasts.}

\item{plot}{FALSE or TRUE}

\item{ylabelLength}{max length of the labels (characters)}

\item{nbMaxLabel}{number of labels to print}

\item{interface}{Boolean. Is this plot for the interface or commandline?}
}
\value{
A \link{RflomicsSE} or a \link{RflomicsMAE-class} object.
All the results are stored as a named list \code{DiffExpAnal}
in the metadata slot of a given \link{RflomicsSE} object.
Objects are:
\itemize{
  \item stats: data.frame giving a summary of the differential
 statistical analysis results by contrast:
 number of DE features, number of up and down regulated features
  \item setting: Parameters used for the differential analysis
 \item method: The method used for the differential analysis
 \item p.adj.method: The applied p-value correction method
  \item p.adj.cutoff: The cut-off applied for the adjusted p-value
  \item logFC.cutoff: The absolute log FC cut-off
  \item RawDEFres: a list giving for each contrast the raw results of
 the differential analysis method
  \item DEF: a list giving for each contrast a data.frame of non filtered
 differential expressed features with their statistics
  \item TopDEF: a list giving for each contrast a data.frame of
 differential expressed features ordered and filtered by p.adj.cutoff
 with their statistics
 \item mergeDEF: a data frame of 0 and 1 indicating for each features in row,
 if it is DE in a given contrasts in column
 \item contrasts: a data.table of the contrasts used for the differential
 analysis
}

a data.frame with differential analyses summary
}
\description{
This is an interface method which run a differential
analysis on omics datasets stored in an object of class
\link{RflomicsSE} or \link{RflomicsMAE-class}. According to the type
of omics and to a list of contrasts, a differential analysis
is performed for each contrasts.
Two methods are available according to the type of object:
\itemize{
\item For RNAseq data:  the \code{glmFit} function/model of the
\code{edgeR} package is applied.
\item For proteomics and metabolomics data:  the \code{\link{lmFit}}
function/model of the \code{limma} package is applied.
}

\itemize{
   \item filterDiffAnalysis: The filterDiffAnalysis method allows
   filtering the results of the differential analysis based on a
   new cutoff for p-value and fold change.}

\itemize{
   \item setValidContrasts: Set the valid contrasts stored in \code{metadata} slot.}
}
\details{
Functions and parameters used for RNAseq are those recommended in DiCoExpress
workflow (see the paper in reference).
Functions and parameters used for proteomics and metabolomics data are those
recommended in the (Efstathiou *et al.*, 2017)
}
\section{Accessors}{



\itemize{
   \item getDEMatrix: return a matrix of experimental design.}


\itemize{
   \item getDEList: return a vector of union or intersection of differential
   expressed features from list of contrasts.}


\itemize{
   \item getDiffSettings: return a list of differential expression analysis
   settings of a given omics dataset}


\itemize{
   \item getValidContrasts: return a data.frame of validated contrasts}


\itemize{
   \item getDiffStat: Get summary table from diffExpAnalysis analysis}


\itemize{
   \item getDiffAnalysesSummary: ...}
}

\section{Plots}{



\itemize{
   \item plotDiffAnalysis method draws a MAplot, a volcano plot and the
p-values distribution from the results of a differential analysis.}


\itemize{
   \item plotHeatmapDesign method draws a heatmap from the results of a
differential analysis.}


\itemize{
   \item plotBoxplotDE method draws a boxplot showing the expression of
   given differentially expressed feature.}
}

\examples{
# load ecoseed data
library(RFLOMICS)
data(ecoseed.mae)

factorInfo <- data.frame(
  "factorName"   = c("Repeat", "temperature", "imbibition"),
  "factorType"   = c("batch", "Bio", "Bio")
)

# create rflomicsMAE object with ecoseed data
MAE <- RFLOMICS::createRflomicsMAE(
  projectName = "Tests",
  omicsData   = ecoseed.mae,
  omicsTypes  = c("RNAseq","proteomics","metabolomics"),
  factorInfo  = factorInfo)

# Set the statistical model and contrasts to test
formulae <- generateModelFormulae(MAE)
MAE <- setModelFormula(MAE, formulae[[1]])  

# Get the contrasts List and choose the first 3 contrasts of type averaged
contrastList <- generateExpressionContrast(MAE, "averaged")

MAE <- setSelectedContrasts(MAE, contrastList = contrastList[c(1, 2, 3),])

# Run the data preprocessing and perform the differential analysis 
MAE <- runDataProcessing(MAE, SE.name = "protetest",  
                         transformMethod = "log2",
                         normMethod = "median")

MAE <- runDiffAnalysis(MAE, SE.name = "protetest", 
                       method = "limmalmFit")
# or
# MAE[["protetest"]] <- runDiffAnalysis(MAE[["protetest"]], 
#                                       method = "limmalmFit", 
#                                       contrastList = contrastList)

# Filter the results of the differential analysis with new cut-off values 
# for p-value and fold change.
MAE <- filterDiffAnalysis(MAE, SE.name = "protetest",
                          p.adj.cutoff = 0.01,
                          logFC.cutoff = 0)
# or
# MAE[["protetest"]] <- filterDiffAnalysis(MAE[["protetest"]], 
#                                          p.adj.cutoff = 0.01, 
#                                          logFC.cutoff = 0)

# Access to the diff analysis settings
## Get DE matrix from DiffExpAnalysis
head(getDEMatrix(MAE[["protetest"]]))

## Get union or intersection from list of contrasts
getDEList(MAE[["protetest"]], contrasts = "(temperatureMedium - temperatureLow) in mean") 

## Get diff setting
getDiffSettings(MAE[["protetest"]])

# generate plot results of a differential analysis
thiscontrast <- "(temperatureMedium - temperatureLow) in mean"

## generate MAplot from diff analysis
# plotDiffAnalysis(MAE[["protetest"]], 
#                  contrastName = thiscontrast, 
#                  typeofplots = "MA.plot")

## plot the heatmap
# plotHeatmapDesign(MAE[["protetest"]], 
#                   contrastName = thiscontrast)

## plot boxplot with feature expression
# plotBoxplotDE(MAE[["protetest"]], 
#               features = "AT1G47128", 
#               groupColor = "temperature")
# plotBoxplotDE(MAE[["protetest"]], 
#               features = "AT1G79550", 
#               groupColor = "imbibition")

# See runDiffAnalysis for an example that includes plotDiffAnalysis
# See runDiffAnalysis for an example that includes plotHeatmapDesign
# See runDiffAnalysis for an example that includes plotBoxplotDE
# See runDiffAnalysis for an example that includes getDEMatrix
# See runDiffAnalysis for an example that includes getDEList
# See runDiffAnalysis for an example that includes getDiffSettings
}
\references{
Lambert, I., Paysant-Le Roux, C., Colella, S. et al. DiCoExpress: a tool
to process multifactorial RNAseq experiments from quality controls to
co-expression analysis through differential analysis based on contrasts
inside GLM models. Plant Methods 16, 68 (2020).

Efstathiou G, Antonakis AN, Pavlopoulos GA, et al. ProteoSign:
an end-user online differential proteomics statistical analysis platform.
Nucleic Acids Res. 2017;45(W1):W300-W306.
}
\seealso{
\code{\link{getDiffSettings}}, \code{\link{getDEList}},
 \code{\link{getDEMatrix}}

\code{\link{plotDiffAnalysis}}, \code{\link{plotHeatmapDesign}},
\code{\link{plotBoxplotDE}}
}
