% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFLOMICS-Class.R,
%   R/RFLOMICS-Methods_01_load_data.R
\docType{class}
\name{RflomicsSE-class}
\alias{RflomicsSE-class}
\alias{RflomicsSE}
\alias{getDesignMat,RflomicsSE-method}
\alias{getDatasetNames,RflomicsSE-method}
\alias{getOmicsTypes,RflomicsSE-method}
\alias{getFactorNames,RflomicsSE-method}
\alias{getFactorTypes,RflomicsSE-method}
\alias{getBioFactors,RflomicsSE-method}
\alias{getBatchFactors,RflomicsSE-method}
\alias{getMetaFactors,RflomicsSE-method}
\alias{getFactorModalities,RflomicsSE-method}
\title{RflomicsSE Class}
\usage{
\S4method{getDesignMat}{RflomicsSE}(object)

\S4method{getDatasetNames}{RflomicsSE}(object)

\S4method{getOmicsTypes}{RflomicsSE}(object)

\S4method{getFactorNames}{RflomicsSE}(object)

\S4method{getFactorTypes}{RflomicsSE}(object)

\S4method{getBioFactors}{RflomicsSE}(object)

\S4method{getBatchFactors}{RflomicsSE}(object)

\S4method{getMetaFactors}{RflomicsSE}(object)

\S4method{getFactorModalities}{RflomicsSE}(object, factorName)
}
\arguments{
\item{object}{An object of class \link{RflomicsSE}}

\item{factorName}{factor name}
}
\value{
A \code{RflomicsSE} object.
}
\description{
RflomicsSE is a class that extends the \link{SummarizedExperiment} by imposing a structure
on the metadata slot. This class is used by the Rflomics analysis workflow to store the
experimental design, the settings and results of a single omic analysis.
The slot metadata is structured as follows:
}
\section{Slots}{

See \link{SummarizedExperiment}

The slot metadata is structured as follows:
 \itemize{
   \item omicType: the type of omics dataset
   \item design: experimental design
   \item DataProcessing: a list containing the data processing settings and results
   \item PCAlist: a list containing the PCA settings and results
   \item DiffExpAnal: a list containing the Differential Analysis settings and results
   \item CoExpAnal: a list containing the Coexpression Analysis settings and results
   \item DiffExpEnrichAnal: a list containing the enrichment analysis of the list of DE features settings and results
   \item CoExpEnrichAnal: a list containing the enrichment analysis of the list of co-expressed features settings and results
 }
}

\section{Accessors}{



\itemize{
   \item getDesignMat: return a data.frame with experimental design.}


\itemize{
   \item getDatasetNames: return a string with dataset name.}


\itemize{
   \item getOmicsTypes: return a named vector with omics type of dataset
   ("RNAseq", "proteomics", "metabolomics")}


\itemize{
   \item getFactorNames: return a vector with the experimental factor names.}


\itemize{
   \item getFactorTypes: return a named vector with experimental factor types
   ("bio", "batch" or "meta").}


\itemize{
   \item getBioFactors: return a vector with the biological factor names.}


\itemize{
   \item getBatchFactors: return a vector with the batch factor names.}


\itemize{
   \item getMetaFactors: return a vector with the metadata factor names.}


\itemize{
   \item getFactorModalities: return a vector with the modality names of
   selected factor.}
}

\seealso{
\link{SummarizedExperiment}
}
