% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{groupsMNVPlot}
\alias{groupsMNVPlot}
\title{groupsMNVPlot}
\usage{
groupsMNVPlot(counts, groups, normalize = TRUE, xlabels = FALSE)
}
\arguments{
\item{counts}{Matrix with Multi-Nucleotide Variants (MNVs) counts data.}

\item{groups}{List where names are groups labels and elements are patients labels corresponding to rownames in counts.}

\item{normalize}{Boolean value; shall I normalize observed counts?}

\item{xlabels}{Boolean value; shall I display x labels?}
}
\value{
A ggplot2 object.
}
\description{
Plot observed Multi-Nucleotide Variants (MNVs) counts for different groups of patients.
}
\examples{
data(plot_data_examples)
counts <- plot_data_examples[['groups.MNV.plot']][['counts']]
groups <- plot_data_examples[['groups.MNV.plot']][['groups']]
groupsMNVPlot(counts=counts,groups=groups)

}
