% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REMPtools.R
\name{getBackend}
\alias{getBackend}
\title{Get BiocParallel back-end}
\usage{
getBackend(ncore, BPPARAM = NULL, verbose = FALSE)
}
\arguments{
\item{ncore}{Number of cores used for parallel computing. By default max number
of cores available in the machine will be utilized. If \code{ncore = 1}, no
parallel computing is allowed.}

\item{BPPARAM}{An optional \code{BiocParallelParam} instance determining the
parallel back-end to be used during evaluation. If not specified, default
back-end in the machine will be used.}

\item{verbose}{Logical parameter. Should the function be verbose?}
}
\value{
A \code{\link{BiocParallel}} object that can be used for parallel
computing.
}
\description{
\code{getBackend} is used to obtain \code{BiocParallel} Back-end to allow
parallel computing.
}
\examples{
# Non-parallel mode
be <- getBackend(ncore = 1, verbose = TRUE)
be

# parallel mode (2 workers)
be <- getBackend(ncore = 2, verbose = TRUE)
be

}
