% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCyjs-class.R
\name{setNodeColorRule,RCyjs-method}
\alias{setNodeColorRule,RCyjs-method}
\alias{setNodeColorRule}
\title{setNodeColorRule}
\usage{
\S4method{setNodeColorRule}{RCyjs}(
  obj,
  attribute,
  control.points,
  colors,
  mode = c("interpolate", "lookup")
)
}
\arguments{
\item{obj}{an RCyjs instance}

\item{attribute}{a character string, the node attribute category whose value controls color}

\item{control.points}{a list of all possible values of the attribute}

\item{colors}{the corresponding node color, one specified for each of the control.points}

\item{mode}{a character string, either "interpolate" or "lookup"}
}
\value{
no return value
}
\description{
\code{setNodeColorRule} control node color via values of the specified attribute
}
\details{
for interpolate mode, in which the node attribute should be a continusously varying numerical quantity
in-between colors are calculated for in-between values.
for lookup mode, in which the node attribute is a discrete string variable, simple color lookup is performed.
}
\examples{
if(interactive()){
   g <- simpleDemoGraph()
   rcy <- RCyjs(title="rcyjs demo", graph=g)
   layout(rcy, "cose")
   fit(rcy, 100)
   setNodeColorRule(rcy, "count", c(0, 100), c("green", "red"), mode="interpolate")
   redraw(rcy)
   }

}
