% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkSelection.R
\name{selectNodes}
\alias{selectNodes}
\title{Select Nodes}
\usage{
selectNodes(
  nodes,
  by.col = "SUID",
  preserve.current.selection = TRUE,
  network = NULL,
  base.url = .defaultBaseUrl
)
}
\arguments{
\item{nodes}{List of node SUIDs, names or other column values}

\item{by.col}{Node table column to lookup up provide node values. Default is 
'SUID'.}

\item{preserve.current.selection}{\code{boolean} Whether to maintain 
previously selected nodes.}

\item{network}{(optional) Name or SUID of the network. Default is the 
"current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
\code{list} of newly selected node SUIDs
}
\description{
Select nodes in the network by SUID, name or other column values.
}
\examples{
\donttest{
selectNodes()
}
}
\author{
AlexanderPico, Tanja Muetze, Georgi Kolishovski, Paul Shannon
}
