% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkViews.R
\name{exportPS}
\alias{exportPS}
\title{Export PS}
\usage{
exportPS(
  filename = NULL,
  exportTextAsFont = TRUE,
  hideLabels = FALSE,
  network = NULL,
  base.url = .defaultBaseUrl,
  overwriteFile = TRUE
)
}
\arguments{
\item{filename}{(\code{character}) Full path or path relative to current 
working directory, in addition to the name of the file. Extension is 
automatically added based on the \code{type} argument. If blank, the current
network name will be used.}

\item{exportTextAsFont}{(optional): If TRUE (the default value), texts will be exported as fonts.}

\item{hideLabels}{(optional): TRUE makes node and edge labels invisible in image. False allows them to be
drawn. The default is False.}

\item{network}{(optional) Name or SUID of a network or view. Default is the 
"current" network active in Cytoscape. The first (presummably only) view 
associated a network is used if a specific view SUID is not provided.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}

\item{overwriteFile}{(optional) FALSE allows Cytoscape show a message box before overwriting the file if the file already
exists; TRUE allows Cytoscape to overwrite it without asking. Default value is TRUE.}
}
\value{
server response
}
\description{
Saves the current network view as an ps file.
}
\details{
Exports the current view to a graphics file and returns the path to 
the saved file. To speed up image export for large networks use the option 'allGraphicsDetails=FALSE'.
Available for Cytoscape v3.10 or later.
}
\examples{
\donttest{
exportPS('/fullpath/myNetwork')
}
}
