% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CyNDEx.R
\name{exportNetworkToNDEx}
\alias{exportNetworkToNDEx}
\title{Export Network To NDEx}
\usage{
exportNetworkToNDEx(
  username,
  password,
  isPublic,
  network = NULL,
  metadata = NULL,
  ndex.url = "http://ndexbio.org",
  ndex.version = "v2",
  base.url = .defaultBaseUrl
)
}
\arguments{
\item{username}{NDEx account username}

\item{password}{NDEx account password}

\item{isPublic}{(Boolean) Whether to make the network publicly 
accessible at NDEx.}

\item{network}{(optional) Name or SUID of the network. Default is the "current" 
network active in Cytoscape.}

\item{metadata}{(optional) A list of structured information describing the network}

\item{ndex.url}{(optional) For alternative instances or deployments of NDEx; 
default is "http://ndexbio.org"}

\item{ndex.version}{(optional) For alternative versions of the NDEx API; 
default is "v2"}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
NDEx identifier (\code{externalId}) for new submission
}
\description{
Send a copy of a Cytoscape network to NDEx as a new submission.
}
\examples{
\donttest{
exportNetworkToNDEx("user", "pass", TRUE)
}
}
