% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Networks.R
\name{createGraphFromNetwork}
\alias{createGraphFromNetwork}
\title{createGraphFromNetwork}
\usage{
createGraphFromNetwork(network = NULL, base.url = .defaultBaseUrl)
}
\arguments{
\item{network}{(optional) Name or SUID of the network. Default is the "current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
A Bioconductor graph object.
}
\description{
Returns the Cytoscape network as a Bioconductor graph.
}
\examples{
\donttest{cw <- CytoscapeWindow('network', graph=make_graphnel())
g <- createGraphFromNetwork()
g <- createGraphFromNetwork('myNetwork')
}
}
\author{
Alexander Pico, Tanja Muetze, Georgi Kolishovski, Paul Shannon
}
