% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Annotations.R
\name{UpdateAnnotationBoundedText}
\alias{UpdateAnnotationBoundedText}
\title{Update Bounded Text Annotation}
\usage{
UpdateAnnotationBoundedText(
  text = NULL,
  annotationName = NULL,
  x.pos = NULL,
  y.pos = NULL,
  fontSize = NULL,
  fontFamily = NULL,
  fontStyle = NULL,
  color = NULL,
  angle = NULL,
  type = NULL,
  customShape = NULL,
  fillColor = NULL,
  opacity = NULL,
  borderThickness = NULL,
  borderColor = NULL,
  borderOpacity = NULL,
  height = NULL,
  width = NULL,
  name = NULL,
  canvas = NULL,
  z.order = NULL,
  network = NULL,
  base.url = .defaultBaseUrl
)
}
\arguments{
\item{text}{The text to be displayed}

\item{annotationName}{Name of annotation by UUID or Name}

\item{x.pos}{(optional) X position in pixels from left; default is center 
of current view}

\item{y.pos}{(optional) Y position in pixels from top; default is center 
of current view}

\item{fontSize}{(optional) Numeric value; default is 12}

\item{fontFamily}{(optional) Font family; default is Arial}

\item{fontStyle}{(optional) Font style; default is}

\item{color}{(optional) Hexidecimal color; default is #000000 (black)}

\item{angle}{(optional) Angle of text orientation; default is 0.0 
(horizontal)}

\item{type}{(optional) The type of the shape, default is RECTANGLE.
See getNodeShapes() for valid options.}

\item{customShape}{(optional) If a custom shape, this is the text of the 
shape}

\item{fillColor}{(optional) Hexidecimal color; default is #000000 (black)}

\item{opacity}{(optional) Opacity of fill color. Must be an integer between 
0 and 100; default is 100.}

\item{borderThickness}{(optional) Integer}

\item{borderColor}{(optional) Hexidecimal color; default is #000000 (black)}

\item{borderOpacity}{(optional) Integer between 0 and 100; default is 100.}

\item{height}{(optional) Height of bounding shape; default is based on text
height.}

\item{width}{(optional) Width of bounding shape; default is based on text
length.}

\item{name}{(optional) Name of annotation object; default is "Text"}

\item{canvas}{(optional) Canvas to display annotation, i.e., foreground 
(default) or background}

\item{z.order}{(optional) Arrangement order specified by number (larger
values are in front of smaller values); default is 0}

\item{network}{(optional) Name or SUID of the network. Default is the 
"current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is 
http://localhost:1234 and the latest version of the CyREST API supported by
this version of RCy3.}
}
\value{
A named list of annotation properties, including UUID
}
\description{
Adds a bounded text annotation to a Cytoscape network view. The 
object will also be added to the Annotation Panel in the GUI.
}
\examples{
\donttest{
UpdateAnnotationBoundedText("test1", "annotationName")
UpdateAnnotationBoundedText("test2", "annotationName", 1000, 1000, name="B2")
UpdateAnnotationBoundedText("test3", "annotationName", 1200, 1000, 30, "Helvetica", 
"bold", "#990000", 40, name="B3", canvas="foreground",z=4)
}
}
