% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sandbox.R
\name{sandboxSet}
\alias{sandboxSet}
\title{sandboxSet}
\usage{
sandboxSet(
  sandboxName,
  copySamples = TRUE,
  reinitialize = TRUE,
  base.url = .defaultBaseUrl
)
}
\arguments{
\item{sandboxName}{Name of new default sandbox. None means to use the original default sandbox}

\item{copySamples}{True to copy the Cytoscape sampleData into the sandbox}

\item{reinitialize}{True to delete sandbox contents (if any) if sandbox already exists}

\item{base.url}{Ignore unless you need to specify a custom domain, port or version to connect to the CyREST API. Default is http://127.0.0.1:1234 and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
sandbox path in Cytoscape workstation's file system
}
\description{
Set a new default sandbox, creating it if necessary.
A sandbox is the root for the file system used for all file operations. When running standalone
on the same workstation as Cytoscape, the default sandbox is the directory that's current for
the R kernel. When running in a Notebook or remote server, the default sandbox is the
'default_sandbox' created automatically under the under the filetransfer directory in the
CytoscapeConfiguration directory. Naming a sandbox with this function creates a new
sub-directory as a sibling to 'default_sandbox' and uses it for subsequent file operations.
Setting a None sandbox uses the default sandbox instead.
Sandboxes are highly recommended as an aid to creating workflows that can be shared with
others.
}
\examples{
\donttest{
sandboxSet()
}
}
