% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sandbox.R
\name{sandboxSendTo}
\alias{sandboxSendTo}
\title{sandboxSendTo}
\usage{
sandboxSendTo(
  sourceFile,
  destFile = NULL,
  overwrite = TRUE,
  sandboxName = NULL,
  base.url = .defaultBaseUrl
)
}
\arguments{
\item{sourceFile}{Name of file to read (as absolute path or sandbox-relative path)}

\item{destFile}{Name of file in the R workflow's file system ... if None, use file name in source_file}

\item{overwrite}{Name of sandbox containing file. None means "the current sandbox".}

\item{sandboxName}{Name of sandbox containing file. None means "the current sandbox".}

\item{base.url}{Ignore unless you need to specify a custom domain, port or version to connect to the CyREST API. Default is http://127.0.0.1:1234 and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
sandboxSendTo
}
\description{
Transfer a file to a sandbox.
The source file is transferred to the named (or current) sandbox, overwriting an existing file if one
already exists. The destFile can be an absolute path if the sandbox is the entire file system (i.e., for
standalone R execution) or a path relative to the sandbox (i.e., for Notebook or remote execution or if a
sandbox was explicitly created).
Note that there is no function that transfers an entire directory. Note, though, that when using sandboxSet()
to make a sandbox current, it is possible to copy the Cytoscape sample data directories into to the sandbox at the
same time.
}
\examples{
\donttest{
sandboxSendTo()
}
}
