% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Layouts.R
\name{layoutCopycat}
\alias{layoutCopycat}
\title{Copy a layout from one network to another}
\usage{
layoutCopycat(
  sourceNetwork,
  targetNetwork,
  sourceColumn = "name",
  targetColumn = "name",
  gridUnmapped = TRUE,
  selectUnmapped = TRUE,
  base.url = .defaultBaseUrl
)
}
\arguments{
\item{sourceNetwork}{(\code{character}) The name of network to get node coordinates from}

\item{targetNetwork}{(\code{character}) The name of the network to apply coordinates to}

\item{sourceColumn}{(optional \code{character}) The name of column in the sourceNetwork node 
table used to match nodes; default is 'name'}

\item{targetColumn}{(optional \code{character}) The name of column in the targetNetwork node 
table used to match nodes; default is 'name'}

\item{gridUnmapped}{(optional \code{character}) If this is set to true, any nodes in the target 
network that could not be matched to a node in the source network will be laid out in a grid; 
default is TRUE}

\item{selectUnmapped}{optional \code{character}) If this is set to true, any nodes in the target network 
that could not be matched to a node in the source network will be selected in the target network; 
default is TRUE}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
None
}
\description{
Sets the coordinates for each node in the target network to the 
coordinates of a matching node in the source network.
}
\details{
Optional parameters such as \code{gridUnmapped} and \code{selectUnmapped} 
determine the behavior of target network nodes that could not be matched.
}
\examples{
\donttest{
layoutCopycat('network1','network2')
}
}
