% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_estNPresp.R
\name{estNPresp}
\alias{estNPresp}
\title{Estimate the taxon-wise response functions non-parametrically}
\usage{
estNPresp(
  sampleScore,
  muMarg,
  X,
  ncols,
  thetas,
  n,
  coefInit,
  coefInitOverall,
  dfSpline,
  vgamMaxit,
  degree,
  verbose,
  allowMissingness,
  naId,
  ...
)
}
\arguments{
\item{sampleScore}{a vector of length n with environmental scores}

\item{muMarg}{the offset matrix}

\item{X}{the n-by-p data matrix}

\item{ncols}{an integer, the number of columns of X}

\item{thetas}{a vector of length p with dispersion parameters}

\item{n}{an integer, the number of samples}

\item{coefInit}{a 2-by-p matrix with current taxon-wise parameter estimates}

\item{coefInitOverall}{a vector of length 2 with current overall parameters}

\item{dfSpline}{a scalar, the degrees of freedom for the smoothing spline.}

\item{vgamMaxit}{Maximal number of iterations in the fitting of the GAM model}

\item{degree}{The degree if the parametric fit if the VGAM fit fails}

\item{verbose}{a boolean, should number of failed fits be reported}

\item{allowMissingness}{A boolean, are missing values present}

\item{naId}{The numeric index of the missing values in X}

\item{...}{further arguments, passed on to the VGAM:::vgam() function

The negative binomial likelihood is still maximized,
 but now the response function is a non-parametric one.
 To avoid a perfect fit and overly flexible functions,
 we enforce smoothness restrictions. In practice we use a
 generalized additive model (GAM), i.e. with splines.
 The same fitting procedure is carried out ignoring species labels.
  We do not normalize the parameters related to the splines:
  the psis can be calculated afterwards.}
}
\value{
A list with components
\item{taxonCoef}{The fitted coefficients of the sample-wise response curves}
\item{splinesList}{A list of all the B-spline objects}
\item{rowMar}{The row matrix}
\item{overall}{The overall fit ignoring taxon labels,
 as a list of coefficients and a spline}
\item{rowVecOverall}{The overall row vector, ignoring taxon labels}
}
\description{
Estimate the taxon-wise response functions non-parametrically
}
