% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plotFeatureBoundaryCoverage}
\alias{plotFeatureBoundaryCoverage}
\title{plotFeatureBoundaryCoverage}
\usage{
plotFeatureBoundaryCoverage(cvgF, cvgT, featureName)
}
\arguments{
\item{cvgF}{data.frame object containing 'fiveprime' coverage data returned 
by getFeatureBoundaryCoverage function}

\item{cvgT}{data.fram object containing 'threeprime' coverage data returned 
by getFeatureBoundaryCoverage function}

\item{featureName}{character object. This is used to label the axes (e.g.
transcripts, exons)}
}
\value{
a plotly htmlwidget is returned
}
\description{
This function is used to create interactive plots displaying 5' and 3'
end coverage profiles of given transcript features.
}
\examples{
data(queryRegions)
data(gff)
txdb <- txdbmaker::makeTxDbFromGRanges(gff)
transcriptCoords <- GenomicFeatures::transcripts(txdb)
cvgF <- getFeatureBoundaryCoverage (queryRegions = queryRegions,
                                    featureCoords = transcriptCoords,
                                    flankSize = 100,
                                    boundaryType = 'fiveprime',
                                    sampleN = 1000)
                                    
cvgT <- getFeatureBoundaryCoverage (queryRegions = queryRegions,
                                    featureCoords = transcriptCoords,
                                    flankSize = 100,
                                    boundaryType = 'threeprime',
                                    sampleN = 1000)
p <- plotFeatureBoundaryCoverage(cvgF = cvgF, 
                                 cvgT = cvgT, 
                          featureName = 'transcript')   
                                                          
}
