% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif_analysis.R
\name{findDifferentialMotifs}
\alias{findDifferentialMotifs}
\title{Find Differential Motifs}
\usage{
findDifferentialMotifs(
  querySeqs,
  controlSeqs,
  motifWidth = 6,
  motifN = 1,
  nCores = 1,
  maxMismatch = 1
)
}
\arguments{
\item{querySeqs}{A DNAStringSet object that is the regions of interest.}

\item{controlSeqs}{A DNAStrintSet object that serve as the control}

\item{motifWidth}{A Positive integer (default: 6) for the generated k-mers. Warning: we recommend
using values below 10 as the computation gets exponentially difficult as the 
motif width is increased.}

\item{motifN}{A positive integer (default:1) denoting the maximum number of 
motifs that should be returned by the \code{findDifferentialMotifs} function}

\item{nCores}{A positive integer (default:1) number of cores used for 
parallel execution.}

\item{maxMismatch}{A positive integer (default: 1) - maximum number of
mismatches to allow when searching for k-mer matches in sequences.}
}
\description{
Find Differential Motifs
}
\examples{
data(queryRegions)

# get query and control sequences
querySeqs <- extractSequences(queryRegions[1:500], 'hg19')
controlRegions <- createControlRegions(queryRegions[1:500])
controlSeqs <- extractSequences(controlRegions, 'hg19')

#run motif discovery
motifResults <- findDifferentialMotifs(querySeqs = querySeqs, 
                                       controlSeqs = controlSeqs, 
                                       motifWidth = 5,
                                       motifN = 1,
                                       maxMismatch = 0, 
                                       nCores = 1)
#summarize motif results
getMotifSummaryTable(motifResults)
}
