% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UserFunctions.R
\name{QP_Pmf}
\alias{QP_Pmf}
\title{Computes the probability mass function of the scores.}
\usage{
QP_Pmf(q_p, q_m, q_z, q_r, n_p, n_m, n_z, epsilon = 1e-16)
}
\arguments{
\item{q_p}{Expected number of positive predictions.}

\item{q_m}{Expected number of negative predictions.}

\item{q_z}{Expected number of nil predictions.}

\item{q_r}{Expected number of regulated predictions.}

\item{n_p}{Number of positive predictions from experiments.}

\item{n_m}{Number of negative predictions from experiments.}

\item{n_z}{Number of nil predictions from experiments.}

\item{epsilon}{parameter for thresholding probabilities of matrices. Default value is 1e-16.}
}
\value{
Vector of probabilities for scores in the support.
}
\description{
This function computes the probability mass function for the Quaternary Dot
Product Scoring Statistic for signed causal graphs. This includes scores with probabilities strictly 
greater than zero.
}
\details{
This function computes the probability for each score in the support of the distribution.
         The returned value is a vector of probabilities where the 
         returned vector has names set equal to the corresponding scores.

         Setting epsilon to zero will compute the probability mass function without ignoring any matrices 
         with probabilities smaller than epsilon*D_max (D_max is the numerator associated with the matrix of highest
         probability for the given constraints). The default value of 1e-16 is experimentally validated to be 
         a very reasonable threshold. Setting the threshold to higher values which are smaller than 1 will lead to understimating
         the probabilities of each score since more tables will be ignored.
}
\examples{
# Compute the probability mass function of the Quaternary Dot
# Product Scoring Statistic for the given table margins.
pmf <- QP_Pmf(50,50,50,0,50,50,50)

}
\references{
Carl Tony Fakhry, Parul Choudhary, Alex Gutteridge, Ben Sidders, Ping Chen, Daniel Ziemek, and
            Kourosh Zarringhalam. Interpreting transcriptional changes using causal graphs: new methods and
            their practical utility on public networks. BMC Bioinformatics, 17:318, 2016. ISSN 1471-2105.
            doi: 10.1186/s12859-016-1181-8.
           
            Franceschini, A (2013). STRING v9.1: protein-protein interaction networks, with increased coverage 
            and integration. In:'Nucleic Acids Res. 2013 Jan;41(Database issue):D808-15. doi: 10.1093/nar/gks1094. 
            Epub 2012 Nov 29'.
}
\seealso{
\code{\link{QP_Pvalue}}, \code{\link{QP_Support}}
}
\author{
Carl Tony Fakhry, Ping Chen and Kourosh Zarringhalam
}
