% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{computeweight_disp}
\alias{computeweight_disp}
\title{Compute weights for dispersion shift analysis}
\usage{
computeweight_disp(beta, mu, pi, n, k, tail = 10^(-4), bigN = 10^6)
}
\arguments{
\item{beta}{Target for number of successful trials, or dispersion parameter.
Must be strictly positive.}

\item{mu}{Non-negative mean of the uninflated negative binomial
distribution.}

\item{pi}{Zero inflation probability for structural zeros.}

\item{n}{Sample size of \eqn{y}}

\item{k}{Sample size of \eqn{x}}

\item{tail}{Distribution tail trimmed for numerically calculate expectation.
Default is \eqn{10^{-4}}}

\item{bigN}{Sampling numbers for numerically calculate expectation, this
will only be applied when mean parameter is extremely large.
Default is \eqn{10^6}}
}
\value{
A list containing a weight vector (\verb{$weight}) and estimated variance
(\verb{$var}) useful for constructing test statistics.
}
\description{
Given the value of the estimated parameters for zero-inflated negative
binomial distribution (\eqn{\beta}, \eqn{\mu}, \eqn{\pi}), the sample sizes
\eqn{n} and \eqn{k} (by default \eqn{n\geqslant k}), this function computes
weights that target on changes of the dispersion parameter in zero-inflated
negative binomial model.
}
\details{
The function returns a list containing a weight vector and estimated
variance for constructing test statistics.
}
\examples{

set.seed(1)
computeweight_disp(
    beta = 5, mu = 40, pi = 0.1, n = 100, k = 60,
    tail = 10^(-4), bigN = 10^6
)

}
