% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QFeatures-processing.R
\name{QFeatures-processing}
\alias{QFeatures-processing}
\alias{logTransform}
\alias{logTransform,SummarizedExperiment-method}
\alias{logTransform,QFeatures-method}
\alias{scaleTransform}
\alias{scaleTransform,SummarizedExperiment-method}
\alias{scaleTransform,QFeatures-method}
\alias{normalize}
\alias{normalize,SummarizedExperiment-method}
\alias{normalize,QFeatures-method}
\alias{sweep}
\alias{sweep,SummarizedExperiment-method}
\alias{sweep,QFeatures-method}
\alias{normalizeMethods}
\title{QFeatures processing}
\usage{
\S4method{logTransform}{SummarizedExperiment}(object, base = 2, pc = 0)

\S4method{logTransform}{QFeatures}(object, i, name = "logAssay", base = 2, pc = 0)

\S4method{scaleTransform}{SummarizedExperiment}(object, center = TRUE, scale = TRUE)

\S4method{scaleTransform}{QFeatures}(object, i, name = "scaledAssay", center = TRUE, scale = TRUE)

\S4method{normalize}{SummarizedExperiment}(object, method, ...)

\S4method{normalize}{QFeatures}(object, i, name = "normAssay", method, ...)

\S4method{sweep}{SummarizedExperiment}(x, MARGIN, STATS, FUN = "-", check.margin = TRUE, ...)

\S4method{sweep}{QFeatures}(
  x,
  MARGIN,
  STATS,
  FUN = "-",
  check.margin = TRUE,
  ...,
  i,
  name = "sweptAssay"
)
}
\arguments{
\item{object}{An object of class \code{QFeatures} or \code{SummarizedExperiment}.}

\item{base}{\code{numeric(1)} providing the base with respect to which
logarithms are computed. Defaults is 2.}

\item{pc}{\code{numeric(1)} with a pseudocount to add to the
quantitative data. Useful when (true) 0 are present in the
data. Default is 0 (no effect).}

\item{i}{A numeric vector or a character vector giving the index or the
name, respectively, of the assay(s) to be processed.}

\item{name}{A \code{character(1)} naming the new assay name. Defaults
are \code{logAssay} for \code{logTransform}, \code{scaledAssay} for
\code{scaleTranform} and \code{normAssay} for \code{normalize}.}

\item{center}{\code{logical(1)} (default is \code{TRUE}) value or
numeric-alike vector of length equal to the number of columns
of \code{object}. See \code{\link[base:scale]{base::scale()}} for details.}

\item{scale}{\code{logical(1)} (default is \code{TRUE}) or a numeric-alike
vector of length equal to the number of columns of
\code{object}. See \code{\link[base:scale]{base::scale()}} for details.}

\item{method}{\code{character(1)} defining the normalisation method to
apply. See Details.}

\item{...}{Additional parameters passed to inner functions.}

\item{x}{An object of class \code{QFeatures} or \code{SummarizedExperiment}
in \code{sweep}.}

\item{MARGIN}{As in \code{\link[base:sweep]{base::sweep()}}, a vector of indices giving the
extent(s) of \code{x} which correspond to \code{STATS}.}

\item{STATS}{As in \code{\link[base:sweep]{base::sweep()}}, the summary statistic which is
to be swept out.}

\item{FUN}{As in \code{\link[base:sweep]{base::sweep()}}, the function to be used to carry
out the sweep.}

\item{check.margin}{As in \code{\link[base:sweep]{base::sweep()}}, a \code{logical}.  If \code{TRUE}
(the default), warn if the length or dimensions of \code{STATS} do
not match the specified dimensions of \code{x}.  Set to \code{FALSE} for
a small speed gain when you know that dimensions match.}
}
\value{
An processed object of the same class as \code{x} or \code{object}.
}
\description{
This manual page describes common quantitative proteomics data
processing methods using \link{QFeatures} objects. In the following
functions, if \code{object} is of class \code{QFeatures}, and optional assay
index or name \code{i} can be specified to define the assay (by name of
index) on which to operate.

The following functions are currently available:
\itemize{
\item \code{logTransform(object, base = 2, i, pc = 0)} log-transforms (with
an optional pseudocount offset) the assay(s).
\item \code{normalize(object, method, i)} normalises the assay(s) according
to \code{method} (see Details).
\item \code{scaleTransform(object, center = TRUE, scale = TRUE, i)} applies
\code{\link[base:scale]{base::scale()}} to \code{SummarizedExperiment} and \code{QFeatures}
objects.
\item \code{sweep(x, MARGIN, STATS, FUN = "-", check.margin = TRUE, ...)}
sweeps out array summaries from \code{SummarizedExperiment} and
\code{QFeatures} objects. See \code{\link[base:sweep]{base::sweep()}} for details.
}

See the \emph{Processing} vignette for examples.
}
\details{
The \code{method} parameter in \code{normalize} can be one of \code{"sum"},
\code{"max"}, \code{"center.mean"}, \code{"center.median"}, \code{"div.mean"},
\code{"div.median"}, \code{"diff.median"}, \verb{"quantiles}", \verb{"quantiles.robust}"
or \code{"vsn"}. The \code{\link[MsCoreUtils:normalize]{MsCoreUtils::normalizeMethods()}} function returns
a vector of available normalisation methods.
\itemize{
\item For \code{"sum"} and \code{"max"}, each feature's intensity is divided by
the maximum or the sum of the feature respectively. These two
methods are applied along the features (rows).
\item \code{"center.mean"} and \code{"center.median"} center the respective
sample (column) intensities by subtracting the respective column
means or medians. \code{"div.mean"} and \code{"div.median"} divide by the
column means or medians. These are equivalent to \code{sweep}ing the
column means (medians) along \code{MARGIN = 2} with \code{FUN = "-"} (for
\code{"center.*"}) or \code{FUN = "/"} (for \code{"div.*"}).
\item \code{"diff.median"} centers all samples (columns) so that they all
match the grand median by subtracting the respective columns
medians differences to the grand median.
\item Using \code{"quantiles"} or \code{"quantiles.robust"} applies (robust) quantile
normalisation, as implemented in \code{\link[preprocessCore:normalize.quantiles]{preprocessCore::normalize.quantiles()}}
and \code{\link[preprocessCore:normalize.quantiles.robust]{preprocessCore::normalize.quantiles.robust()}}. \code{"vsn"} uses the
\code{\link[vsn:vsn2]{vsn::vsn2()}} function.  Note that the latter also glog-transforms the
intensities.  See respective manuals for more details and function
arguments.
}

For further details and examples about normalisation, see
\code{\link[MsCoreUtils:normalize]{MsCoreUtils::normalize_matrix()}}.
}
\examples{

MsCoreUtils::normalizeMethods()
}
