% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polytect_plot.R
\name{polytect_plot}
\alias{polytect_plot}
\title{Plotting function for clustering results}
\usage{
polytect_plot(df_data, cluster_num, cluster_selected = TRUE)
}
\arguments{
\item{df_data}{A data frame containing partition fluorescence intensities and corresponding cluster label. This can be the output
of \code{polytect_clust} and \code{polytect_merge} or any data frame containing the above information.}

\item{cluster_num}{the expected number of clusters}

\item{cluster_selected}{Indicator of whether all the clusters are present in the plots. If TRUE, then only selected ones (the ones only positive
in the selected 2 dimensions) are shown. The default value is "TRUE".}
}
\value{
2-color plots.
}
\description{
This function takes results from polytect_clust and polytect_merge, or a data frame containing flurescence intensities and partition
labels. It will output all combination of 2-color plots.
}
\examples{
data(HR)
df_data<-polytect_clust(HR,4)
polytect_plot(df_data,4)
}
