% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_funcs.R
\name{split_large_pg_PG}
\alias{split_large_pg_PG}
\title{Splits too large PGs in proteogenomics context}
\usage{
split_large_pg_PG(adj, size_max, adj_rna_pg)
}
\arguments{
\item{adj}{Adjacency matrix between peptides and PGs.}

\item{size_max}{Maximum PG size desired.}

\item{adj_rna_pg}{Adjacency matrix between mRNA and PGs.}
}
\value{
List containing new adjacency matrix between peptides and PGs, 
and new adjacency matrix between mRNA and PGs.
}
\description{
Randomly splits PGs with too many peptides/precursors, while 
keeping other PGs untouched, and adapts adjacency matrix between mRNA and 
PGs accordingly. The new PGs created all have size equal to size_max 
(including peptides and mRNAs). Hence, some peptides and mRNA can be
 duplicated in the new PGs.
}
\examples{
data(subropers)
split.obj <- split_large_pg_PG(subropers$adj, 5, subropers$adj_rna_pg)

}
