% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsePhyloProfile.R
\name{getTaxonomyMatrix}
\alias{getTaxonomyMatrix}
\title{Get taxonomy matrix}
\usage{
getTaxonomyMatrix(taxDB = NULL, subsetTaxaCheck = FALSE, taxonIDs = NULL)
}
\arguments{
\item{taxDB}{Path to the taxonomy DB files}

\item{subsetTaxaCheck}{TRUE/FALSE subset taxonomy matrix based on input taxon
IDs. Default = FALSE}

\item{taxonIDs}{list of input taxon IDs (e.g. ncbi1234). Default = NULL}
}
\value{
Data frame contains the (subset of) taxonomy matrix for list of
input taxa.
}
\description{
Get the (full or subset) taxonomy matrix from
"data/taxonomyMatrix.txt" based on an input taxon list
}
\examples{
# get full pre-installed taxonomy matrix
getTaxonomyMatrix()
# get taxonomy matrix for a list of taxon IDs
taxonIDs <- c("ncbi9606", "ncbi10116")
getTaxonomyMatrix(NULL, TRUE, taxonIDs)
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
