% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umapClustering.R
\name{addDimRedTaxaColors}
\alias{addDimRedTaxaColors}
\title{Add colors for taxa in dimension reduction plot}
\usage{
addDimRedTaxaColors(plotDf = NULL, colorPalette = "Set2",
    highlightTaxa = NULL)
}
\arguments{
\item{plotDf}{data for dimension reduction plot}

\item{colorPalette}{color palette. Default: "Set2"}

\item{highlightTaxa}{list of taxa to be highlighted}
}
\value{
A dataframe for dimension reduction plot with an additional column
for the assigned color to each taxon
}
\description{
Add colors for taxa in dimension reduction plot
}
\examples{
rawInput <- system.file(
   "extdata", "test.main.long", package = "PhyloProfile", mustWork = TRUE
)
longDf <- createLongMatrix(rawInput)
data4dimRed <- prepareDimRedData(longDf, "phylum")
dimRedCoord <- dimReduction(data4dimRed)
plotDf <- createDimRedPlotData(dimRedCoord, data4dimRed)
PhyloProfile:::addDimRedTaxaColors(plotDf, colorPalette = "Set2")
}
\seealso{
\code{\link{prepareDimRedData}}, \code{\link{dimReduction}},
\code{\link{createDimRedPlotData}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
