% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsePhylotree.R
\name{sortTaxaFromTree}
\alias{sortTaxaFromTree}
\title{Get sorted supertaxon list based on a rooted taxonomy tree}
\usage{
sortTaxaFromTree(tree)
}
\arguments{
\item{tree}{an "phylo" object for a rooted taxonomy tree}
}
\value{
A list of sorted taxa obtained the input taxonomy tree.
}
\description{
Get sorted supertaxon list based on a rooted taxonomy tree
}
\examples{
data("ppTaxonomyMatrix", package = "PhyloProfile")
# create taxonomy tree rooted by ncbi10090
tree <- createUnrootedTree(ppTaxonomyMatrix)
rootedTree <- ape::root(tree, outgroup = "ncbi10090", resolve.root = TRUE)
# get taxon list sorted from tree
sortTaxaFromTree(rootedTree)
}
\seealso{
\code{\link{ppTaxonomyMatrix}} for a demo taxonomy matrix data
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
