% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsePhyloProfile.R
\name{sortInputTaxa}
\alias{sortInputTaxa}
\title{Sort list of (super)taxa based on a selected reference (super)taxon}
\usage{
sortInputTaxa(taxonIDs = NULL, rankName, refTaxon = NULL,
    taxaTree = NULL, sortedTaxonList = NULL, taxDB = NULL)
}
\arguments{
\item{taxonIDs}{list of taxon IDs (e.g.: ncbi1234, ncbi9999, ...). Default =
NULL}

\item{rankName}{working taxonomy rank (e.g. "species", "phylum",...)}

\item{refTaxon}{selected reference taxon. Default = NULL}

\item{taxaTree}{taxonomy tree for the input taxa (optional). Default = NULL}

\item{sortedTaxonList}{list of sorted taxa (optional). Default = NULL}

\item{taxDB}{Path to the taxonomy DB files}
}
\value{
A taxonomy matrix for the input taxa ordered by the selected
reference taxon. This matrix is sorted either based on the NCBI taxonomy
info, or based on an user-defined taxonomy tree (if provided).
}
\description{
Sort list of (super)taxa based on a selected reference (super)taxon
}
\examples{
taxonIDs <- c(
    "ncbi10116", "ncbi123851", "ncbi3702", "ncbi13616", "ncbi9606"
)
sortInputTaxa(taxonIDs, "species", "Homo sapiens", NULL, NULL)
}
\seealso{
\code{\link{getNameList}}, \code{\link{getTaxonomyMatrix}},
\code{\link{createUnrootedTree}}, \code{\link{sortTaxaFromTree}},
\code{\link{getInputTaxaName}}, \code{\link{getInputTaxaID}},
\code{\link{createLongMatrix}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
