% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDomainPlot.R
\name{resolveOverlapFeatures}
\alias{resolveOverlapFeatures}
\title{Modify domain dataframe to resolve overlapped domains/features}
\usage{
resolveOverlapFeatures(domainDf)
}
\arguments{
\item{domainDf}{input domain dataframe}
}
\value{
Domain dataframe with modified feature names that join multiple
domains of the same type that are not overlapped
}
\description{
Modify domain dataframe to resolve overlapped domains/features
}
\examples{
# get domain data
seedID <- "101621at6656"
domainFile <- system.file(
    "extdata", "domainFiles/101621at6656.domains",
    package = "PhyloProfile", mustWork = TRUE
)
domainDf <- parseDomainInput(seedID, domainFile, "file")
# get seedDf and orthoDf
subDf <- domainDf[
    domainDf$seedID ==
    "101621at6656#101621at6656:AGRPL@224129@0:224129_0:001955:1",]
orthoDf <- subDf[subDf$orthoID == "101621at6656:DROME@7227@1:Q9VG04",]
# resolve overlapped featuers
PhyloProfile:::resolveOverlapFeatures(orthoDf)
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
