% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umapClustering.R
\name{plotDimRed3D}
\alias{plotDimRed3D}
\title{Create dimension reduction 3D plot}
\usage{
plotDimRed3D(plotDf = NULL, legendPos = "bottom",
    colorPalette = "Set2", transparent = 0,highlightTaxa = NULL,
    dotZoom = 0)
}
\arguments{
\item{plotDf}{data for dimension reduction 3D plot}

\item{legendPos}{position of legend. Default: "right"}

\item{colorPalette}{color palette. Default: "Set2"}

\item{transparent}{transparent level (from 0 to 1). Default: 0}

\item{highlightTaxa}{list of taxa to be highlighted}

\item{dotZoom}{dot size zooming factor. Default: 0}
}
\value{
A plot as ggplot object
}
\description{
Create dimension reduction 3D plot
}
\examples{
rawInput <- system.file(
   "extdata", "test.main.long", package = "PhyloProfile", mustWork = TRUE
)
longDf <- createLongMatrix(rawInput)
data4dimRed <- prepareDimRedData(longDf, "phylum")
dimRedCoord3d <- dimReduction(data4dimRed, dimension = "3d")
plotDf <- createDimRedPlotData(dimRedCoord3d, data4dimRed)
plotDimRed3D(plotDf)
}
\seealso{
\code{\link{prepareDimRedData}}, \code{\link{dimReduction}},
\code{\link{createDimRedPlotData}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
