% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umapClustering.R
\name{plotDimRed}
\alias{plotDimRed}
\title{Create dimension reduction plot}
\usage{
plotDimRed(plotDf = NULL, legendPos = "bottom",
    colorPalette = "Set2", transparent = 0, textSize = 12, font = "Arial",
    highlightTaxa = NULL, dotZoom = 0)
}
\arguments{
\item{plotDf}{data for dimension reduction 2D plot}

\item{legendPos}{position of legend. Default: "right"}

\item{colorPalette}{color palette. Default: "Set2"}

\item{transparent}{transparent level (from 0 to 1). Default: 0}

\item{textSize}{size of axis and legend text. Default: 12}

\item{font}{font of text. Default = Arial"}

\item{highlightTaxa}{list of taxa to be highlighted}

\item{dotZoom}{dot size zooming factor. Default: 0}
}
\value{
A plot as ggplot object
}
\description{
Create dimension reduction plot
}
\examples{
rawInput <- system.file(
   "extdata", "test.main.long", package = "PhyloProfile", mustWork = TRUE
)
longDf <- createLongMatrix(rawInput)
data4dimRed <- prepareDimRedData(longDf, "phylum")
dimRedCoord <- dimReduction(data4dimRed)
plotDf <- createDimRedPlotData(dimRedCoord, data4dimRed)
plotDimRed(plotDf, font = "sans")
}
\seealso{
\code{\link{prepareDimRedData}}, \code{\link{dimReduction}},
\code{\link{createDimRedPlotData}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
