% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsePhyloProfile.R
\name{parseInfoProfile}
\alias{parseInfoProfile}
\title{Parsing info for phylogenetic profiles}
\usage{
parseInfoProfile(inputDf, sortedInputTaxa, taxaCount, coorthoCOMax)
}
\arguments{
\item{inputDf}{input profiles in long format}

\item{sortedInputTaxa}{sorted taxonomy data for the input taxa
(check sortInputTaxa())}

\item{taxaCount}{dataframe counting present taxa in each supertaxon}

\item{coorthoCOMax}{maximum number of co-orthologs allowed}
}
\value{
A dataframe contains all info for the input phylogenetic profiles.
This full processed profile that is required for several profiling analyses
e.g. estimation of gene age (?estimateGeneAge) or identification of core gene
(?getCoreGene).
}
\description{
Creating main dataframe for the input phylogenetic profiles
based on selected input taxonomy level (e.g. strain, species) and reference
taxon. The output contains the number of paralogs, the max/min/mean/median
of VAR1 and VAR2.
}
\examples{
library(dplyr)
data("mainLongRaw", package="PhyloProfile")
taxonIDs <- getInputTaxaID(mainLongRaw)
sortedInputTaxa <- sortInputTaxa(
    taxonIDs, "class", "Mammalia", NULL, NULL
)
taxaCount <- sortedInputTaxa \%>\% dplyr::group_by(supertaxon) \%>\%
    summarise(n = n(), .groups = "drop")
coorthoCOMax <- 999
parseInfoProfile(
    mainLongRaw, sortedInputTaxa, taxaCount, coorthoCOMax
)
}
\seealso{
\code{\link{createLongMatrix}}, \code{\link{sortInputTaxa}},
\code{\link{calcPresSpec}}, \code{\link{mainLongRaw}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
