% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareTaxaGroups.R
\name{generateSinglePlot}
\alias{generateSinglePlot}
\title{Create a single violin distribution plot}
\usage{
generateSinglePlot(plotDf, parameters, variable)
}
\arguments{
\item{plotDf}{dataframe for plotting containing values for each variable in
in-group and out-group.}

\item{parameters}{plot parameters, including size of x-axis, y-axis,
legend and title; position of legend ("right", "bottom" or "none");
mean/median point; names of in-group and out-group; and plot title.
NOTE: Leave blank or NULL to use default values.}

\item{variable}{name of variable that need to be plotted (one of the column
names of input dataframe plotDf).}
}
\value{
A violin plot as a ggplot object.
}
\description{
Create a single violin distribution plot
}
\examples{
data("mainLongRaw", package="PhyloProfile")
data <- mainLongRaw
inGroup <- c("ncbi9606", "ncbi10116")
varNames <- colnames(data)[c(4, 5)]
plotDf <- dataVarDistTaxGroup(data, inGroup, "101621at6656", varNames)
plotParameters <- list(
    "xSize" = 12,
    "ySize" = 12,
    "titleSize" = 15,
    "legendSize" = 12,
    "legendPosition" = "right",
    "mValue" = "mean",
    "inGroupName" = "In-group",
    "outGroupName" = "Out-group",
    "title" = "101621at6656"
)
generateSinglePlot(plotDf, plotParameters, colnames(plotDf)[1])
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
