% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadSignatures.R
\name{downloadPertSig}
\alias{downloadPertSig}
\title{Download Drug Perturbation Signatures}
\usage{
downloadPertSig(
  name,
  saveDir = file.path(".", "PSets", "Sigs"),
  fileName,
  verbose = TRUE,
  ...,
  myfn
)
}
\arguments{
\item{name}{A \code{character(1)} string, the name of the PharmacoSet for which
to download signatures. The name should match the names returned in the
\verb{PSet Name} column of \code{availablePSets(canonical=FALSE)}.}

\item{saveDir}{A \code{character(1)} string with the folder path where the
PharmacoSet should be saved. Defaults to \code{"./PSets/Sigs/"}. Will
create directory if it does not exist.}

\item{fileName}{\code{character(1)} What to name the downloaded file. Defaults
to '\code{name}_signature.RData' when excluded.}

\item{verbose}{\code{logical(1)} Should \code{downloader} show detailed messages?}

\item{...}{\code{pairlist} Force subsequent arguments to be named.}

\item{myfn}{\code{character(1)} A deprecated version of \code{fileName}. Still works
for now, but will be deprecated in future releases.}
}
\value{
An array type object contaning the signatures
}
\description{
This function allows you to download an array of drug perturbation
signatures, as would be computed by the \code{drugPerturbationSig} function,
for the available perturbation \code{PharmacoSets}. This function allows the
user to skip these very lengthy calculation steps for the datasets available,
and start their analysis from the already computed signatures
}
\examples{

\dontrun{
    if (interactive()) downloadPertSig("CMAP_2016")
}

}
