% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RobustReg.R
\name{RobustReg}
\alias{RobustReg}
\title{Robust Regression}
\usage{
RobustReg(dat, logged = FALSE)
}
\arguments{
\item{dat}{a dataframe or matrix of peptide abundance, or a SummarizedExperiment object where
grouping and peptide-protein mapping are provided in colData and rowData, respectively.}

\item{logged}{Boolean variable indicating whether abundance data have been
log-transformed}
}
\value{
\code{RobustReg} returns a numeric vector of estimated protein abundance.
}
\description{
Estimate protein abundance by fitting a linear model to peptide abundance via robust regression.
}
\examples{
# Generate random peptide data
dat <- 2^matrix(rnorm(600), ncol = 6)
colnames(dat) <- paste0("Sample", 1:6)
rownames(dat) <- paste0("Peptide", 1:100)

RobustReg(dat, logged = FALSE)

}
\references{
Sticker, A, Goeminne, L, Martens, L, and Clement, L (2020). Robust Summarization and Inference in Proteome-wide Label-free Quantification. \emph{Molecular & Cellular Proteomics} 19, 1209-19.

Gatto, L, Rainer, J, and Gibb, S (2021). MsCoreUtils: Core Utils for Mass Spectrometry Data. R packageversion 1.4.0. https://github.com/RforMassSpectrometry/MsCoreUtils
}
\author{
Junmin Wang
}
