% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinship.R
\name{kinship}
\alias{kinship}
\alias{kinship,Ped-method}
\alias{kinship,character-method}
\alias{kinship,Pedigree-method}
\title{Kinship matrix}
\usage{
\S4method{kinship}{Ped}(obj, chrtype = "autosome")

\S4method{kinship}{character}(obj, dadid, momid, sex, chrtype = "autosome")

\S4method{kinship}{Pedigree}(obj, chrtype = "autosome")
}
\arguments{
\item{obj}{A Pedigree or Ped object or a vector of subject identifiers.}

\item{chrtype}{chromosome type.  The currently supported types are
'autosome' and 'X'.}

\item{dadid}{A vector containing for each subject, the identifiers of the
biologicals fathers.}

\item{momid}{A vector containing for each subject, the identifiers of the
biologicals mothers.}

\item{sex}{A character, factor or numeric vector corresponding to
the gender of the individuals. This will be transformed to an ordered factor
with the following levels:
\code{male} < \code{female} < \code{unknown}

The following values are recognized:
\itemize{
\item "male": "m", "male", "man", \code{1}
\item "female": "f", "female", "woman", \code{2}
\item "unknown": "unknown", \code{3}
}}
}
\value{
\subsection{When obj is a vector}{

A matrix of kinship coefficients.
}

\subsection{When obj is a Pedigree}{

A matrix of kinship coefficients ordered by families present
in the Pedigree object.
}
}
\description{
Compute the kinship matrix for a set of related autosomal subjects.
The function is generic, and can accept a Pedigree, a Ped or a vector as
the first argument.
}
\details{
The function will usually be called with a Pedigree.
The call with a Ped or a vector is provided for backwards compatibility
with an earlier release of the library that was less capable.
Note that when using with a Ped or a vector, any information on
twins is not available to the function.

Warning: This function does not work with adopted individuals.
If you have adopted individuals in your pedigree, you should remove them
before calling this function.

When called with a Pedigree, the routine
will create a block-diagonal-symmetric sparse matrix object of class
\code{dsCMatrix}.  Since the \verb{[i, j]} value of the result is 0 for any two
unrelated individuals i and j and a \code{Matrix} utilizes sparse
representation, the resulting object is often orders of magnitude smaller
than an ordinary matrix.

Two genes G1 and G2 are identical by descent (IBD) if they are both physical
copies of the same ancestral gene; two genes are identical by state if they
represent the same allele.  So the brown eye gene that I inherited from my
mother is IBD with hers; the same gene in an unrelated individual is not.

The kinship coefficient between two subjects is the probability that a
randomly selected allele from a locus will be IBD between them. It is
obviously 0 between unrelated individuals. For an autosomal site and no
inbreeding it will be 0.5 for an individual with themselves, .25 between
mother and child, .125 between an uncle and neice, etc.

The computation is based on a recursive algorithm described in Lange, which
assumes that the founder alleles are all independent.
}
\section{References}{

K Lange, Mathematical and Statistical Methods for
Genetic Analysis, Springer-Verlag, New York, 1997.
}

\examples{

kinship(c("A", "B", "C", "D", "E"), c("C", "D", "0", "0", "0"),
    c("E", "E", "0", "0", "0"), sex = c(1, 2, 1, 2, 1))
kinship(c("A", "B", "C", "D", "E"), c("C", "D", "0", "0", "0"),
    c("E", "E", "0", "0", "0"), sex = c(1, 2, 1, 2, 1),
    chrtype = "x"
)

data(sampleped)
pedi <- Pedigree(sampleped[-16])
kinship(pedi)
}
\seealso{
\code{\link[=make_famid]{make_famid()}}, \code{\link[=kindepth]{kindepth()}}
}
