% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{loadPathoscopeReports}
\alias{loadPathoscopeReports}
\title{Loads all data from a set of PathoID reports.
For each column in the PathoID report, construct a
matrix where the rows are genomes and the columns are samples.
Returns a list where each element is named according to
the PathoID column. For example, ret[["Final.Best.Hit.Read.Numbers"]]
on the result of this function will get you the final count matrix.
Also includes elements "total_reads" and "total_genomes" from the
first line of the PathoID report.}
\usage{
loadPathoscopeReports(reportfiles, nrows = NULL)
}
\arguments{
\item{reportfiles}{Paths to report files}

\item{nrows}{Option to read first N rows of PathoScope reports}
}
\value{
Returns a list where each element is named according to
the PathoID column. For example, ret[["Final.Best.Hit.Read.Numbers"]]
on the result of this function will get you the final count matrix.
Also includes elements "total_reads" and "total_genomes" from the
first line of the PathoID report.
}
\description{
Loads all data from a set of PathoID reports.
For each column in the PathoID report, construct a
matrix where the rows are genomes and the columns are samples.
Returns a list where each element is named according to
the PathoID column. For example, ret[["Final.Best.Hit.Read.Numbers"]]
on the result of this function will get you the final count matrix.
Also includes elements "total_reads" and "total_genomes" from the
first line of the PathoID report.
}
\examples{
input_dir <- system.file("example/data", package = "PathoStat")
reportfiles <- list.files(input_dir, pattern = "*-sam-report.tsv",
full.names = TRUE)
}
