% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRNAPrioritization.R
\name{prioritizeMicroRNA}
\alias{prioritizeMicroRNA}
\title{Prioritize miRNA}
\usage{
prioritizeMicroRNA(
  enriches0,
  pathClust,
  method = "AggInv",
  methodThresh = NULL,
  enrichmentFDR = 0.25,
  topClust = 2,
  sampRate = 1000,
  outDir = ".",
  dataDir = ".",
  saveSampling = TRUE,
  runJackKnife = TRUE,
  saveJackKnife = FALSE,
  numCores = 1,
  saveCSV = TRUE,
  prefix = "",
  autoSeed = TRUE
)
}
\arguments{
\item{enriches0}{miRNA-pathway enrichment dataset obtained from
miRNAPathwayEnrichment.}

\item{pathClust}{Pathway clusters, obtained from
MappingPathwaysClusters.}

\item{method}{Vector of methods pCut, AggInv, AggLog, sumz, sumlog.}

\item{methodThresh}{Vector of methods threshold for each method in method,
if NULL use default thresh values in method.}

\item{enrichmentFDR}{FDR cut-off calculating miRNA-pathway hits
in the input cluster based on significant enrichment readouts.}

\item{topClust}{Top x clusters to perform miRNA prioritization on.}

\item{sampRate}{Sampling rate for CLT.}

\item{outDir}{Output directory.}

\item{dataDir}{Data directory.}

\item{saveSampling}{If TRUE, saves sampling data as RDS for each cluster in
topClust in dataDir.}

\item{runJackKnife}{If TRUE, jacknifing will be performed.}

\item{saveJackKnife}{If TRUE, saves jack-knifed sampling data as RDS for each
cluster in topClust in dataDir.}

\item{numCores}{Number of CPU cores to use, must be at least one.}

\item{saveCSV}{If TRUE, saves CSV file for each cluster in topClust in
outDir.}

\item{prefix}{Prefix for all saved data.}

\item{autoSeed}{random permutations are generated based on predetermined
seeds. TRUE will give identical results in different runs.}
}
\value{
Table of miRNA and p-values, each row contains a miRNA and its
  associated p-values from the methods.
}
\description{
Outputs a table of miRNA ordered with respective p-values derived from
  method for prioritization
}
\examples{
data("miniTestsPanomiR")

prioritizeMicroRNA(enriches0 = miniTestsPanomiR$miniEnrich,
   pathClust = miniTestsPanomiR$miniPathClusts$Clustering,
   topClust = 1,
   sampRate = 50,
   method = c("aggInv"),
   saveSampling = FALSE,
   runJackKnife = FALSE,
   numCores = 1,
   saveCSV = FALSE)
}
