% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{miniTestsPanomiR}
\alias{miniTestsPanomiR}
\title{Readouts and datasets for minimal reproducible examples of the PanomiR.}
\format{
A list of 5:
\describe{
  \item{mini_LIHC_Exp}{a reduced expression dataset from TCGA LIHC data}
  \item{mini_LIHC_Cov}{a reduced covariates dataset from TCGA LIHC data}
  \item{miniEnrich}{a reduced table of miRNA-pathway enrichment, TargetScan.}
  \item{miniDEP}{Differentially activated pathways from reduced TCGA LIHC}
  \item{miniPCXN}{reduced representation of PCXN network}
  \item{miniPathClusts}{miniDEP mapped to miniPCXN}
}
}
\usage{
data(miniTestsPanomiR)
}
\description{
The item miniEnrich is a reduced representation of the TargetScan
For full table use miRNAPathwayEnrichment function in the package
along with msigdb_c2 and targetScan_03 datasets.
}
\details{
These datasets include reduced representation of TCGA LIHC data
for reproducing the pipeline. doi: 10.1016/j.cell.2017.05.046

A reduced representation of PCxN is provided. For full dataset and method
please refer to pcxn.org or https://doi.org/10.1371/journal.pcbi.1006042
}
\examples{
data(miniTestsPanomiR)
}
\keyword{datasets}
