% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetOverview.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{Plot a heatmap of the sample intensities with optional column annotations for a selection of normalization methods}
\usage{
plot_heatmap(
  se,
  ain = NULL,
  color_by = c("Group", "Pool"),
  label_by = NULL,
  only_refs = FALSE
)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomics data set}

\item{ain}{Vector of strings which assay should be used as input (default NULL).
If NULL then all normalization of the se object are plotted next to each other.}

\item{color_by}{Vector of strings specifying the columns to color the samples (If NULL, the condition column of the SummarizedExperiment object is used. If "No", no color bars added.)}

\item{label_by}{String specifying the column in the metadata used to label the samples for the UpSet plot}

\item{only_refs}{Logical, if TRUE, only reference samples (ComRef) are included in the plot}
}
\value{
list of ggplot objects
}
\description{
Plot a heatmap of the sample intensities with optional column annotations for a selection of normalization methods
}
\examples{
data(tuberculosis_TMT_se)
plot_heatmap(tuberculosis_TMT_se, ain = c("log2"), color_by = NULL,
             label_by = NULL, only_refs = FALSE)

}
