% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estPower.R
\name{Power_Disc}
\alias{Power_Disc}
\title{Run DE analysis by using MAST. Here we output two result tables corresponding to two forms of DE genes.
These parameters include four gene-wise parameters and two cell-wise parameters.}
\usage{
Power_Disc(
  DErslt,
  simData,
  alpha = 0.1,
  delta = 0.1,
  strata = seq(0, 1, by = 0.2)
)
}
\arguments{
\item{DErslt}{is from the DE analysis by MAST}

\item{simData}{is the corresponding simulated scRNA-seq dataset (SingCellExperiment)}

\item{alpha}{is the cutoff for the fdr which can be modified}

\item{delta}{or the zero ratio change is the cutoff (=0.1) used to determined the high DE genes for Form II}

\item{strata}{can be modified by the user. By default, it is (0, 0.2], (0.2, 0.4], (0.4, 0.6], (0.6, 0.8], (0.8, 1]}
}
\value{
a list of metrics for power analysis such as: stratified targeted power and marginal power.
}
\description{
Run DE analysis by using MAST. Here we output two result tables corresponding to two forms of DE genes.
These parameters include four gene-wise parameters and two cell-wise parameters.
}
\examples{
data("es_mef_sce")
sce = es_mef_sce[, colData(es_mef_sce)$cellTypes == "fibro"]
set.seed(123)
rix = sample(1:nrow(sce), 500)
sce = sce[rix, ]
estParas = Est2Phase(sce)
simData = Simulate2SCE(n=1000, estParas1 = estParas, estParas2 = estParas)
DErslt = runDE(simData$sce)
Disc_pow = Power_Disc(DErslt, simData)
}
