% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estPara.R
\name{Est2Phase}
\alias{Est2Phase}
\title{Estimate characterized parameters for a given scRNA-seq data (SingleCellExperiment object or a count matrix).}
\usage{
Est2Phase(sce, low.prob = 0.99)
}
\arguments{
\item{sce}{SingleCellExperiment object with assays(sce)[[1]] is the count matrix or input directly}

\item{low.prob}{lower bound probability for phase I}
}
\value{
a list of needed estimated parameters
}
\description{
These parameters include four gene-wise parameters and two cell-wise parameters.
}
\examples{
data("es_mef_sce")
sce = es_mef_sce[, colData(es_mef_sce)$cellTypes == "fibro"]
set.seed(123)
rix = sample(1:nrow(sce), 500)
sce = sce[rix, ]
estParas = Est2Phase(sce)
}
