% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PomaVolcano.R
\name{PomaVolcano}
\alias{PomaVolcano}
\title{Volcano Plot}
\usage{
PomaVolcano(
  data,
  pval_cutoff = 0.05,
  log2fc_cutoff = NULL,
  labels = FALSE,
  x_label = "log2 (Fold Change)",
  y_label = "-log10 (P-value)"
)
}
\arguments{
\item{data}{A data frame with at least three columns: feature names, effect size (e.g., logFC), and statistical significance values. These should be the first three columns of the data, in this order.}

\item{pval_cutoff}{Numeric. Specifies the p-value threshold for significance in the volcano plot. The default is set to 0.05. This parameter determines the horizontal line in the plot indicating the threshold for statistical significance.}

\item{log2fc_cutoff}{Numeric. Specifies the log2 fold change cutoff for the volcano plot. If not provided, the cutoff is set to the 75th percentile of the absolute log2 fold changes in the data. This parameter determines the vertical lines in the plot indicating the magnitude of change threshold.}

\item{labels}{Logical. Indicates whether to plot labels for significant features.}

\item{x_label}{Character. Custom label for the x-axis.}

\item{y_label}{Character. Custom label for the y-axis.}
}
\value{
A \code{ggplot} object representing the volcano plot.
}
\description{
\code{PomaVolcano} creates a volcano plot from a given dataset. This function is designed to visualize the statistical significance (p-value) against the magnitude of change (log2 fold change) for features.
}
\examples{
data <- POMA::st000336 # Example SummarizedExperiment object included in POMA

# T-test
results <- data \%>\%
  PomaImpute() \%>\% 
  PomaUnivariate() \%>\% 
  dplyr::select(feature, fold_change, pvalue)

results \%>\% 
  PomaVolcano(pval_cutoff = 0.05,
              log2fc_cutoff = NULL,
              labels = FALSE,
              x_label = "log2 (Fold Change)",
              y_label = "-log10 (P-value)")
              
# Limma
results <- data \%>\%
  PomaImpute() \%>\% 
  PomaNorm() \%>\% 
  PomaLimma(contrast = "DMD-Controls") \%>\% 
  dplyr::select(feature, log2FC, pvalue)

results \%>\% 
  PomaVolcano(pval_cutoff = 0.05,
              log2fc_cutoff = NULL,
              labels = FALSE,
              x_label = "log2 (Fold Change)",
              y_label = "-log10 (P-value)")
}
\author{
Pol Castellano-Escuder
}
