% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gff2matrix.R
\name{gff2matrix}
\alias{gff2matrix}
\title{Convert GFF to a binary occurrence matrix}
\usage{
gff2matrix(input)
}
\arguments{
\item{input}{A data frame containing GFF data, typically generated by
`rtracklayer::import.gff` and converted to a data frame. It must have
'type', 'start', 'end', and 'seqnames' columns.}
}
\value{
A matrix, where values are binary: `1` indicates the presence of a
  feature, and `0` indicates its absence.
}
\description{
This function takes a GFF data frame and converts it into a binary matrix,
indicating the presence (1) or absence (0) of a feature in a sequence.
}
\examples{
gff_file <- system.file("extdata/out_Hb_gff.txt", package = "PMScanR")
if (nzchar(gff_file)) {
  gff_data <- as.data.frame(rtracklayer::import.gff(gff_file))
  motif_matrix <- gff2matrix(gff_data)
  # print(head(motif_matrix))
}
}
