% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqPie.R
\name{freqPie}
\alias{freqPie}
\title{Create a pie chart showing protein motif distribution}
\usage{
freqPie(data)
}
\arguments{
\item{data}{A data frame in GFF format containing a column named 'Name'
with the names of each protein motif.}
}
\value{
A ggplot object representing the pie chart.
}
\description{
This function calculates the occurrences and percentages for each protein
motif in the 'Name' column of a GFF-like data frame. It then creates a
pie chart using `ggplot2` to visualize the distribution.
}
\examples{
# Create sample data frame similar to parsed GFF output
sample_data <- data.frame(
  seqid = rep(c("Seq1", "Seq2"), each = 5),
  source = rep("PROSITE", 10),
  type = rep("MOTIF", 10),
  start = sample(1:100, 10),
  end = sample(101:200, 10),
  score = runif(10),
  strand = sample(c("+", "-"), 10, replace = TRUE),
  phase = sample(0:2, 10, replace = TRUE),
  Name = sample(c("Zinc_finger", "EGF_domain", "Kinase_domain"), 10, replace = TRUE)
)

# Generate the pie chart
motif_pie_chart <- freqPie(sample_data)
# print(motif_pie_chart)

}
