% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-validateModel.R
\name{validateModel,ConsensusMetaclusteringModel,ConsensusMetaclusteringModel-method}
\alias{validateModel,ConsensusMetaclusteringModel,ConsensusMetaclusteringModel-method}
\title{Compute the Inter-Cohort Cluster Correlation and Clustering Reproducibility
of All Clusters in Each Cohort.}
\usage{
\S4method{validateModel}{ConsensusMetaclusteringModel,ConsensusMetaclusteringModel}(model, valData, ...)
}
\arguments{
\item{model}{A \code{ConsensusMetaclusteringModel} object with cluster_labels in
assigned to each experiment, as returned by \code{predictClasses}.}

\item{valData}{A \code{ConsensusMetaclusteringModel} object with cluster_labels
assigned to each experiment, as returned by \code{predictClasses}. This
consensus cluster should contain outgroup cohorts, such as normal
patients to be compared against the disease cohorts being used for
class discovery.}

\item{...}{Fallthrough parameters to \code{BiocParallel::bpmapply}. This can
also be used to customize the call to \code{stats::cor.test} used for
calculating the cluster thresholds.}
}
\value{
The \code{ConsensusMetaclusteringModel} from object, with the training
data from \code{valData} in the \code{validationData} slot, the models from the
\code{valData} object appended to the \code{models} of object, and the
\code{validationStats} slot populated with pair-wise comparisons between
all experiments in both \code{model} and \code{valData}.
}
\description{
Compute the Inter-Cohort Cluster Correlation and Clustering Reproducibility
of All Clusters in Each Cohort.
}
