% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-validateModel.R
\name{validateModel,ClinicalModel,SurvivalExperiment-method}
\alias{validateModel,ClinicalModel,SurvivalExperiment-method}
\title{Validate a ClinicalModel object with a single SurvivalExperiment object.}
\usage{
\S4method{validateModel}{ClinicalModel,SurvivalExperiment}(model, valData)
}
\arguments{
\item{model}{A \code{ClinicalModel} object which has been trained using
\code{trainModel}.}

\item{valData}{A \code{SurvivalExperiment} to validate the model with.}
}
\value{
The \code{ClinicalModel} with the validation statistics in the
\code{validationStats} slot and the validation data in the \code{validationData} slot.
}
\description{
Validate a ClinicalModel object with a single SurvivalExperiment object.
}
\examples{
data(sampleClinicalModel)
data(sampleCohortList)

# Set parallelization settings
BiocParallel::register(BiocParallel::SerialParam())

# Train Model
trainedClinicalModel <- trainModel(sampleClinicalModel)

# Make predictions
clinicalPredCohortList <- predictClasses(sampleCohortList[c('PCSI', 'TCGA')],
  model=trainedClinicalModel)

# Validate model
validatedClinicalModel <- validateModel(trainedClinicalModel,
  valData=clinicalPredCohortList)

}
