% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-subset.R
\name{subset,CohortList-method}
\alias{subset,CohortList-method}
\title{Subset method for a \code{CohortList}}
\usage{
\S4method{subset}{CohortList}(x, subset = TRUE, select = TRUE, invert = FALSE)
}
\arguments{
\item{x}{A \code{CohortList} object}

\item{subset}{The row query. Defaults to TRUE, i.e., select all.}

\item{select}{The column query. Defaults to TRUE, i.e., select all.}

\item{invert}{A \code{logical} vector indicating if the matches should be
inverted. Default is FALSE.}
}
\value{
A \code{CohortList} containing only the rows and columns selected in i
and j, respectively.
}
\description{
Works using endoapply of \code{[} over the list \code{SurvivalExperiment}s
}
\examples{
data(sampleCohortList)
commonGenes <- findCommonGenes(sampleCohortList)
commonGenesCohortList <- subset(sampleCohortList, subset=commonGenes)

}
