% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-runGSEA.R
\name{runGSEA,PCOSP,data.frame-method}
\alias{runGSEA,PCOSP,data.frame-method}
\title{Run Gene Set Enrichment Analysis On A \code{PCOSP} Model Object.}
\usage{
\S4method{runGSEA}{PCOSP,data.frame}(object, geneSet, numModels, ..., adjMethod = "fdr", allResults = FALSE)
}
\arguments{
\item{object}{A \code{PCOSP} model which has been trained with \code{trainModel}.}

\item{geneSet}{A \code{data.frame} with two columns, the first being the name
of the gene and the second the gene set. The gene names must match the
rownames of \code{object}. Additional columns will be dropped.}

\item{numModels}{The number of models to use when selecting the top features
from the PCOSP model in \code{object}. If missing will default to the top 10\%
of models.}

\item{...}{Force subsequent parameters to be named. Not used.}

\item{adjMethod}{An optional parameter specifying the multiple testing
correction to use in \code{\link[piano:runGSAhyper]{piano::runGSAhyper}}. This parameter must be named.}

\item{allResults}{Return the full results from \code{\link[piano:runGSAhyper]{piano::runGSAhyper}} instead
of a \code{data.frame} of significant results? Default is FALSE. This parameter
must be named.}
}
\value{
A \code{data.table} containing the significantly enriched gene sets.
}
\description{
Run Gene Set Enrichment Analysis On A \code{PCOSP} Model Object.
}
