% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-rankFeatures.R
\name{rankFeatures,SummarizedExperiment-method}
\alias{rankFeatures,SummarizedExperiment-method}
\title{Rank the Features in a \code{SummarizedExperiment} Object}
\usage{
\S4method{rankFeatures}{SummarizedExperiment}(
  object,
  FUN = "rowMads",
  RANK_FUN = "dense_rank",
  ...,
  descending = TRUE,
  assay = 1
)
}
\arguments{
\item{object}{A \code{SummarizedExperiment} to rank the features in.}

\item{FUN}{A row-wise summary function, such as \code{rowVars}, \code{rowMads}, etc.
defaults to \code{MatrixGenerics::rowMads}.}

\item{RANK_FUN}{A ranking function, such as \code{rank} or \code{dense_rank}. Defaults
to \code{dplyr::dense_rank}.}

\item{...}{Fall through arguments to \code{FUN}, such as \code{na.rm=TRUE}.}

\item{descending}{Should your rank function be called with \code{-} before the
values from \code{FUN}. Defaults to \code{TRUE}.}

\item{assay}{\code{integer} assay to use for the ranking, as passed to the
\code{SummarizedExperiment::assay} function. Defaults to the first assay.}
}
\value{
The \code{SummarizedExperiment} with the column \code{feature_score} and
\code{feature_rank} in the \code{rowData} slot. Information about which functions
where used for each column can be found in the object \code{mcols} in the
\code{calculated_with} column.
}
\description{
Rank the Features in a \code{SummarizedExperiment} Object
}
\examples{
data(sampleICGCmicro)
rankFeatures(sampleICGCmicro, FUN='rowMads', RANK_FUN='dense_rank')

}
