% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-S4Model.R
\name{modelParams}
\alias{modelParams}
\title{Generic for Accessing the Model Parameters of an \code{S4} Object}
\usage{
modelParams(object, ...)
}
\arguments{
\item{object}{A \code{S4} Object.}

\item{...}{Allow additional arguments to be defined for this generic.}
}
\value{
A \code{List}- or \code{list}-like object containing all the parameters needed
to reproduce a specific model training run, including environmental
settings like the random seed and RNGkind.
}
\description{
Generic for Accessing the Model Parameters of an \code{S4} Object
}
\examples{
data(CSPC_MAE)
set.seed(1987)
metaclustModel <- ConMetaclustModel(CSPC_MAE, randomSeed=1987)
modelParams(metaclustModel)


}
