% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-getTopFeatures.R
\name{getTopFeatures,SummarizedExperiment-method}
\alias{getTopFeatures,SummarizedExperiment-method}
\title{Get the Top Ranked Features in a \code{SummarizedExperiment} object}
\usage{
\S4method{getTopFeatures}{SummarizedExperiment}(object, numFeats, ..., rankCol = "feature_rank")
}
\arguments{
\item{object}{A \code{SummarizedExperiment} to extract top features from}

\item{numFeats}{An \code{integer} number of top ranked features to extract.}

\item{...}{Fall through arguments to \code{rankFeatures}, which is used to
calculate the ranks if \code{rankCol} is not present the object \code{rowData}.}

\item{rankCol}{The name of the column containing the integer feature ranks.
Defaults to \code{feature_rank}, as calculated with \code{rankFeatures}, but users
can alternatively specify their own custom rank column if desired.}
}
\value{
A \code{character} vector of top ranked features, with the features in
order of rank ascending.
}
\description{
Get the Top Ranked Features in a \code{SummarizedExperiment} object
}
\examples{
data(sampleICGCmicro)
getTopFeatures(sampleICGCmicro, numFeats=20)

}
