% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-compareModels.R
\name{compareModels,SurvivalModel,SurvivalModel-method}
\alias{compareModels,SurvivalModel,SurvivalModel-method}
\title{Compare Two \code{SurivalModel} Objects, Returing A \code{ModelComparison} Object
With Statistics Comparing the Performance of Each Model.}
\usage{
\S4method{compareModels}{SurvivalModel,SurvivalModel}(model1, model2, modelNames)
}
\arguments{
\item{model1}{An object inherting from the \code{SurvivalModel} class.}

\item{model2}{Another object inherting from the \code{SurvivalModel} class}

\item{modelNames}{Optional character vector with a name for each model.
Defaults to the class of the model plus 1 and 2 if missing.}
}
\value{
A \code{ModelComparison} object with statistics comparing the two models.
}
\description{
Compare Two \code{SurivalModel} Objects, Returing A \code{ModelComparison} Object
With Statistics Comparing the Performance of Each Model.
}
\examples{
data(sampleValPCOSPmodel)
data(sampleClinicalModel)
data(sampleCohortList)

# Set parallelization settings
BiocParallel::register(BiocParallel::SerialParam())

# Train the model
trainedClinicalModel <- trainModel(sampleClinicalModel)

# Predict risk/risk-class
ClinicalPredPCSI <- predictClasses(sampleCohortList[c('PCSI', 'TCGA')],
  model=trainedClinicalModel)

# Validate the models
validatedClinicalModel <- validateModel(trainedClinicalModel,
  valData=ClinicalPredPCSI)

# Compare the models
modelComp <- compareModels(sampleValPCOSPmodel, validatedClinicalModel)
head(modelComp)

}
